/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import noppes.npcs.CustomRegisters;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.reflection.item.ItemFoodReflection;
import noppes.npcs.util.Util;

public class CustomFood
extends ItemFood
implements ICustomElement {
    protected NBTTagCompound nbtData;

    public CustomFood(int amount, float saturation, boolean isWolfFood, NBTTagCompound nbtItem) {
        super(amount, saturation, isWolfFood);
        NBTTagCompound potionEffect;
        Potion potion;
        this.nbtData = nbtItem;
        this.setRegistryName("customnpcs", "custom_" + nbtItem.func_74779_i("RegistryName"));
        this.func_77655_b("custom_" + nbtItem.func_74779_i("RegistryName"));
        if (nbtItem.func_150297_b("UseDuration", 3)) {
            ItemFoodReflection.setItemUseDuration(this, nbtItem.func_74762_e("UseDuration"));
        }
        if (nbtItem.func_150297_b("PotionEffect", 10) && (potion = Potion.func_180142_b((String)(potionEffect = nbtItem.func_74775_l("PotionEffect")).func_74779_i("Potion"))) != null) {
            PotionEffect effect = new PotionEffect(potion, potionEffect.func_74762_e("DurationTicks"), potionEffect.func_74762_e("Amplifier"), potionEffect.func_74767_n("Ambient"), potionEffect.func_74767_n("ShowParticles"));
            this.func_185070_a(effect, potionEffect.func_74760_g("Probability"));
        }
        if (nbtItem.func_150297_b("AlwaysEdible", 1) && nbtItem.func_74767_n("AlwaysEdible")) {
            this.func_77848_i();
        }
        if (nbtItem.func_150297_b("IsFull3D", 1) && nbtItem.func_74767_n("IsFull3D")) {
            this.func_77664_n();
        }
        this.func_77637_a(CustomRegisters.tabItems);
    }

    @Override
    public String getCustomName() {
        return this.nbtData.func_74779_i("RegistryName");
    }

    @Override
    public INbt getCustomNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.nbtData);
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return this.field_77855_a;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (tab != CustomRegisters.tabItems && tab != CreativeTabs.field_78027_g) {
            return;
        }
        if (this.nbtData != null && this.nbtData.func_150297_b("ShowInCreative", 1) && !this.nbtData.func_74767_n("ShowInCreative")) {
            return;
        }
        items.add((Object)new ItemStack((Item)this));
        if (tab == CustomRegisters.tabItems) {
            Util.instance.sort(items);
        }
    }

    @Override
    public int getType() {
        if (this.nbtData != null && this.nbtData.func_150297_b("ItemType", 1)) {
            return this.nbtData.func_74771_c("ItemType");
        }
        return 6;
    }
}

